-- Macro_Scripts File
-- Purpose:  define action for each creatable Nurbs surfaces and curves objects to hook up to the create main menu (or quads)

/*
Revision History

	22 Jan 2004, Pierre-Felix Breton
		
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	
	24 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------
macroScript Point_Surf 
            category:~OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"Objects NURBS" 
			tooltip:~POINT_SURFACE_TOOLTIP~ 
			ButtonText:~POINT_SURFACE_BUTTONTEXT~
            icon:#("NURBSSurface",1)
(
	on execute do (Try(StartObjectCreation Point_Surf) Catch () )
        on isChecked return (mcrUtils.IsCreating Point_Surf)
)

--------------------------------------------------------------------------------------------
macroScript CV_Surf 
            category:~CV_SURF_OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"Objects NURBS" 
            tooltip:~CV_SURFACE_TOOLTIP~
			ButtonText:~CV_SURFACE_BUTTONTEXT~ 
            icon:#("NURBSSurface",2)
(
	on execute do (Try(StartObjectCreation NURBSSurf) Catch())
        on isChecked return (mcrUtils.IsCreating NURBSSurf)
)

--------------------------------------------------------------------------------------------
macroScript Point_Curve 
            category:~POINT_CURVE_OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"NObjects NURBSURBS" 
            tooltip:~POINT_CURVE_TOOLTIP~ 
            buttontext:~POINT_CURVE_BUTTONTEXT~ 
            Icon:#("NURBScurve",1)
(
   on execute do StartObjectCreation Point_Curve
   on isChecked return mcrUtils.IsCreating Point_Curve
)

--------------------------------------------------------------------------------------------
macroScript CV_Curve 
            category:~CV_CURVE_OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"Objects NURBS" 
            tooltip:~CV_CURVE_TOOLTIP~ 
            buttontext:~CV_CURVE_BUTTONTEXT~ 
            Icon:#("NURBScurve",2)
(
   on execute do StartObjectCreation CV_Curve
   on isChecked return mcrUtils.IsCreating CV_Curve 
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCtAaMoxFkGfha/4HdByJgTIxxwY3fcrLEE
-- 26bNmDZlAZhWm288G9HyPrpTEELeyaPtfPiig2LPyhmHkWbSL6Ux0WSGaUpRps02
-- uav18vW0IaziX3r+1ZWq3jsyNb9cSpAl5pa0Tj5irC2HWJbINcmzqbrPIuY+3y6f
-- esBBfGMkVNIsJPTXYwExsZK1OzX+gRUdhqUepKqn5cBNGVwYOatttyeZEQC+qb8j
-- aodNqIA1RH/CQPOLoSvY8MkHFFAw/ASUWp2V4OPa933Ky0qE9Hubrdyc0yj2JZqv
-- AID/1ONtTiqdp1AVyvfypvob11iVHHRVLJHbH4tsPxIpRLuGsqjP
-- -----END-SIGNATURE-----